#include <struct.h>
#include "CDlg.h"

BOOL CGeomBarDlg::OnInitDialog()
{
  for (int i = 0; i < NumTools; i++)
    ((CButton*)GetDlgItem(IDC_CHECK1+i))->SetCheck(
      (nBitButtons & (0x1<<i))>>i);
  return TRUE;
}

afx_msg void  CGeomBarDlg::OnOK()
{
  nBitButtons = 0;
  for (int i = 0; i < NumTools; i++)
    nBitButtons |= 
    (((CButton*)GetDlgItem(IDC_CHECK1+i))->GetCheck()<<i);
  EndDialog(IDOK);
}




//------------------------------------------
//  Tool:
extern DWORD  nButtons;
extern short  nNumButtons;

DWORD CALLBACK GeometryBarOnLoad(tProcParams* params)
{
  nNumButtons = 4;
  CString folder = "Plugins settings\\DialogBox\\GeometryBar\0";
  nButtons = params->pApp->GetProfileInt(folder, "Buttons", 0xFF);
  return Z3D_PLUGRESULT_ENABLEPROC;
}

DWORD CALLBACK GeometryBarUnload(tProcParams* params)
{
  CString folder = "Plugins settings\\DialogBox\\GeometryBar\0";
  params->pApp->WriteProfileInt(folder, "Buttons", nButtons);
  return 0;
}

DWORD CALLBACK GeometryBarActivate(tProcParams* params)
{
  AfxSetResourceHandle(params->DllHandle);


  CGeomBarDlg diag(nButtons, nNumButtons);
  if (diag.DoModal() == IDOK)
    nButtons = diag.nBitButtons;

  AfxSetResourceHandle(params->AppHandle);
  return 0;
}